///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "TCP/Definitions.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

class Client
{
    public:
        // --------------(Function Prototypes)-----------------------------------------------------
        bool FreeClientSend(void);			        // Frees the clients send memory
        bool FreeClientReceive(void);			    // Frees the clients receive memory
        bool FreeClientSendReceive(void);		    // Frees the clients send & receive memory

        char *PeekSendData(void);
        char *PeekReceiveData(void);

        int PeekSizeOfSendData(void);
        int PeekSizeOfReceiveData(void);

        bool DisconnectClient(void); 			    // Disconnect client

        bool IsDataReady(void);

        bool SetSendDataEx(char *, int);
        bool SetSendData(char *);
        bool GetReceiveData(char *, int *);

        bool DoSendData(void);					    // Send data to remote client
		bool DoReceiveData(void);				    // Receive data from remote client

        bool Connect(char *, int);				    // Connect to remote client

        bool Start(void);				            // Starts the service on a specific port
        bool Stop(void); 				            // Stops the service

        int WriteLineToClient(char *);			    // Write String To Remote Client
        int WriteLineToClientEx(char *, int);       // Write Unicode String To Remote Client

        Client::Client(void);  // Class constructor
        Client::~Client(void); // Class destructor

        // Thread management
        bool CreateNewTCPThread(void);
        bool SuspendTCPThread(void);            // Suspend the TCPThread
        bool ResumeTCPThread(void);             // Resume the TCPThread
        bool KillTCPThread(void);               // Terminate the TCPThread
        bool IsTCPThreadActive(void);           // Check TCPThread for activity

        // --------------(Variable Declerations)-----------------------------------------------------
    	bool Connected;		   // Remote client's connection flag
    	bool Disconnect;	   // Remote client's disconnect flag
        bool RawMode;          //-
    	SOCKET Socket;		   // Remote client's socket

        int RecvOffset;

        //--------( Socket Variables )
        fd_set ReadFDS; 					// FDS Read
        fd_set WriteFDS;					// FDS Write
        fd_set ExceptFDS;					// FDS Except

        struct timeval TimeOut; 			// TimeOut

        // Thread Variables
        friend DWORD  WINAPI _TCPThreadFunction(LPVOID);

    protected:
        // --------------(Variable Declerations)-----------------------------------------------------
    	char *SendData;		   // Remote client's data to be sent
    	int SizeOfSendData;	   // Remote client's size of data to be sent (Bytes)

    	char *ReceiveData;	   // Remote client's receive buffer
    	int SizeOfReceiveData; // Remote client's size of received data (Bytes)

        HANDLE TCPThreadHandle; // Thread handle
        bool TCPThreadActive;   // Activity indicator
        DWORD TCPThreadID;      // Thread ID
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Client::Client(void)
{
    Socket = 0;

    Connected    = false;
    Disconnect   = false;

    RawMode      = false;

   	SendData    = NULL;
   	ReceiveData = NULL;

    RecvOffset        = 0;
   	SizeOfSendData    = 0;
   	SizeOfReceiveData = 0;

    TCPThreadHandle = NULL;
    TCPThreadActive = false;
    TCPThreadID     = 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Client::~Client(void)
{
    
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "TCP/Functions.H"

#include "TCP/TCPBuffer.H"

#include "TCP/Start.H"
#include "TCP/Stop.H"

#include "TCP/Connect.H"

#include "TCP/Send.H"
#include "TCP/Receive.H"

#include "TCP/Threading.H"

Client MyClient;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

